export const DotsIcons = () => (
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.334 10a1.667 1.667 0 1 1 3.333 0 1.667 1.667 0 0 1-3.333 0zM8.334 4.167a1.667 1.667 0 1 1 3.333 0 1.667 1.667 0 0 1-3.333 0zM8.334 15.833a1.667 1.667 0 1 1 3.333 0 1.667 1.667 0 0 1-3.333 0z"
            fill="#4B5563"
        />
    </svg>
);

export const ViewIcon = () => (
    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M1.412 7.417c-.08-.125-.12-.188-.142-.285a.684.684 0 0 1 0-.261c.023-.097.062-.16.142-.286.656-1.04 2.61-3.667 5.588-3.667s4.932 2.628 5.589 3.667c.08.126.119.189.141.286a.684.684 0 0 1 0 .26c-.022.098-.062.16-.141.286-.657 1.04-2.61 3.668-5.589 3.668-2.978 0-4.932-2.628-5.588-3.668z"
            stroke="#000"
            strokeWidth="1.167"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M7 8.751a1.75 1.75 0 1 0 0-3.5 1.75 1.75 0 0 0 0 3.5z"
            stroke="#000"
            strokeWidth="1.167"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

export const TrashIcon = () => (
    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M5.25 1.75h3.5m-7 1.75h10.5m-1.167 0-.409 6.136c-.061.92-.092 1.381-.29 1.73a1.75 1.75 0 0 1-.758.709c-.362.175-.823.175-1.746.175H6.12c-.923 0-1.384 0-1.746-.175a1.75 1.75 0 0 1-.757-.709c-.2-.349-.23-.81-.291-1.73L2.916 3.5m2.917 2.625v2.917m2.334-2.917v2.917"
            stroke="#D92D0B"
            strokeWidth="1.167"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

export const BreadcrumbSeparatorIcon = () => (
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M6 12L10 8L6 4" stroke="#4B5563" strokeWidth="1.33333" strokeLinecap="round" strokeLinejoin="round" />
    </svg>
);

export const ErrorIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M12 17c.283 0 .52-.096.713-.288A.968.968 0 0 0 13 16a.968.968 0 0 0-.287-.713A.968.968 0 0 0 12 15a.968.968 0 0 0-.713.287A.968.968 0 0 0 11 16c0 .283.096.52.287.712.192.192.43.288.713.288zm-1-4h2V7h-2v6zm1 9a9.738 9.738 0 0 1-3.9-.788 10.099 10.099 0 0 1-3.175-2.137c-.9-.9-1.612-1.958-2.137-3.175A9.738 9.738 0 0 1 2 12c0-1.383.263-2.683.788-3.9a10.099 10.099 0 0 1 2.137-3.175c.9-.9 1.958-1.612 3.175-2.137A9.738 9.738 0 0 1 12 2c1.383 0 2.683.263 3.9.788a10.098 10.098 0 0 1 3.175 2.137c.9.9 1.613 1.958 2.137 3.175A9.738 9.738 0 0 1 22 12a9.738 9.738 0 0 1-.788 3.9 10.098 10.098 0 0 1-2.137 3.175c-.9.9-1.958 1.613-3.175 2.137A9.738 9.738 0 0 1 12 22z"
            fill="#D92D0B"
        />
    </svg>
);

export const ArrowReverse = () => (
    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M2.333 4.083h5.834a3.5 3.5 0 1 1 0 7H2.333m0-7L4.667 1.75M2.333 4.083l2.334 2.334"
            stroke="#000"
            strokeWidth="1.167"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

export const CloseIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M17 7 7 17M7 7l10 10"
            stroke="currentColor"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

export const TriangleIcon = () => (
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.678 1.39a1.667 1.667 0 0 0-1.355 0c-.333.148-.549.409-.7.621-.147.21-.306.483-.48.784l-6.89 11.9c-.174.301-.333.576-.441.809-.11.237-.228.555-.19.918.048.47.295.898.677 1.176.295.214.63.271.89.295.256.023.573.023.922.023H16.89c.349 0 .666 0 .922-.023.26-.024.594-.08.89-.295.382-.278.628-.706.677-1.176.038-.363-.08-.681-.19-.918a10.943 10.943 0 0 0-.442-.81l-6.89-11.9a10.856 10.856 0 0 0-.48-.783c-.15-.212-.367-.473-.7-.621zm.156 6.11a.833.833 0 0 0-1.667 0v3.333a.833.833 0 0 0 1.667 0V7.5zM10 13.333A.833.833 0 0 0 10 15h.009a.833.833 0 0 0 0-1.667H10z"
            fill="#F29718"
        />
    </svg>
);

export const WarningIcon = () => (
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10 .832a9.167 9.167 0 1 0 0 18.333A9.167 9.167 0 0 0 10 .832zm0 5a.833.833 0 1 0 0 1.667h.009a.833.833 0 0 0 0-1.667h-.008zm.834 4.167a.833.833 0 1 0-1.667 0v3.333a.833.833 0 1 0 1.667 0V9.999z"
            fill="#F29718"
        />
    </svg>
);

export const ProfileIcon = () => (
    <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M6 40c4.672-4.955 11.014-8 18-8 6.986 0 13.328 3.045 18 8m-9-25a9 9 0 1 1-18 0 9 9 0 0 1 18 0z"
            stroke="#060C1A"
            strokeWidth="4"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

/**
 * @since 4.4.0
 */
export const EditIcon = () => (
    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M6.417 2.331h-2.45c-.98 0-1.47 0-1.845.19a1.75 1.75 0 0 0-.765.766c-.19.374-.19.864-.19 1.844v4.9c0 .98 0 1.47.19 1.845.168.329.436.597.765.764.375.191.865.191 1.845.191h4.9c.98 0 1.47 0 1.844-.19a1.75 1.75 0 0 0 .765-.765c.19-.375.19-.865.19-1.845v-2.45m-7 1.75h.978c.285 0 .428 0 .562-.032.119-.029.233-.076.337-.14.118-.072.219-.173.42-.375l5.579-5.578a1.237 1.237 0 1 0-1.75-1.75L5.213 7.034c-.201.202-.302.303-.374.42a1.167 1.167 0 0 0-.14.338c-.032.134-.032.277-.032.562v.977z"
            stroke="#4B5563"
            strokeWidth="1.167"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

/**
 * @since 4.4.0
 */
export const SetAsPrimaryIcon = () => (
    <svg
        width="14"
        height="14"
        viewBox="0 0 14 14"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        aria-hidden="true"
    >
        <path d="M7 4.668v4.667M4.667 7h4.666" stroke="#4B5563" strokeWidth="1.167" strokeLinecap="round" strokeLinejoin="round"/>
        <path d="M1.75 4.55c0-.98 0-1.47.19-1.844a1.75 1.75 0 0 1 .766-.765c.374-.191.864-.191 1.844-.191h4.9c.98 0 1.47 0 1.845.19.329.169.597.436.764.766.191.374.191.864.191 1.844v4.9c0 .98 0 1.47-.19 1.845a1.75 1.75 0 0 1-.766.764c-.374.191-.864.191-1.844.191h-4.9c-.98 0-1.47 0-1.844-.19a1.75 1.75 0 0 1-.765-.766c-.191-.374-.191-.864-.191-1.844v-4.9z" stroke="#000" strokeWidth="1.167" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>
);

/**
 * @since 4.4.0
 */
export const AddressBlankSlateIcon = () => (
    <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M10 28.573C6.297 30.206 4 32.483 4 35c0 4.97 8.954 9 20 9s20-4.03 20-9c0-2.518-2.297-4.794-6-6.427M36 16c0 8.127-9 12-12 18-3-6-12-9.873-12-18 0-6.627 5.373-12 12-12s12 5.373 12 12zm-10 0a2 2 0 1 1-4 0 2 2 0 0 1 4 0z"
            stroke="#9CA0AF"
            strokeWidth="4"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

/**
 * @since 4.4.0
 */
export const CustomFieldsBlankSlateIcon = () => (
    <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M32.586 12.586a2 2 0 0 1 2.828 0l10 10a2 2 0 0 1 0 2.829l-10 10a2 2 0 1 1-2.828-2.829L41.172 24l-8.586-8.585a2 2 0 0 1 0-2.829zM15.414 12.586a2 2 0 0 1 0 2.829L6.828 24l8.586 8.586a2 2 0 1 1-2.828 2.829l-10-10a2 2 0 0 1 0-2.829l10-10a2 2 0 0 1 2.828 0zM28.434 4.048a2 2 0 0 1 1.518 2.386l-8 36a2 2 0 0 1-3.904-.867l8-36a2 2 0 0 1 2.386-1.519z"
            fill="#9CA0AF"
        />
    </svg>
);

/**
 * @since 4.6.0
 */
export const RefundIcon = () => (
    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M5.08 2.164a.583.583 0 0 0-.826-.825L1.921 3.672a.583.583 0 0 0 0 .825L4.254 6.83a.583.583 0 0 0 .825-.825L3.742 4.668h4.425a2.917 2.917 0 0 1 0 5.833H2.333a.583.583 0 0 0 0 1.167h5.834a4.083 4.083 0 0 0 0-8.167H3.742l1.337-1.337z" fill="#000"/>
    </svg>
);
